<?php
  /**
   * Search
   *
   * @package Digital Downloads Pro
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: search.php, v2.00 2011-07-10 10:12:05 gewa Exp $
   */
  define("_VALID_PHP", true);
  require_once("init.php");

  $keywords = post('keywords');
  $keywords = str_replace("%", '', $keywords);
  $keywords = sanitize($keywords,20,false);
  $keywords = $db->escape($keywords);
  
  $searchrow = $content->getSearchResults($keywords);
?>
<?php include("header.php");?>
<!-- Start Search-->
<?php if (!$keywords || strlen($keywords = trim($keywords)) == 0):?>
<h2><em>نتـایِج جستجـو</em></h2>
<?php $core->msgAlert("<span>!تـوجـه</span>. لطفـا برای جستجـو، کلمـات کلیـدی را در کـادر جستجـو وارد نمائیـد",false);?>
<?php elseif(!$searchrow):?>
<h2><em>نتـایِج جستجـو</em></h2>
<?php $core->msgAlert("<span>!تـوجـه</span> . نتیـجه ایی نـداشـت. لطفـا با کمی تغییـر دوباره سعی نمائیـد <strong>$keywords</strong> متـاسفیـم، جستجـوی شمـا بـرای",false);?>
<?php else:?>
<h2><em><?php echo $keywords;?> &laquo; نتـایـج جستجـو بـرای </em></h2>
  <div id="catlist">
    <div class="rightblock">
      <?php include( BASEPATH . "plugins/cart.php");?>
      <?php include( BASEPATH . "plugins/popular.php");?>
      <?php include( BASEPATH . "plugins/advert.php");?>
    </div>
    <div class="rightblock">
      <div id="catview">
        <?php foreach($searchrow as $crow):?>
        <div class="catview-wrap" id="list_<?php echo $crow['pid'];?>">
          <?php $thumb = ($crow['thumb']) ? PRODIMGURL . 'thumbs/' . $crow['thumb'] : UPLOADURL . 'blank.png';?>
          <?php $url = ($core->seo) ? $core->site_url . '/view-item/' . intval($crow['pid']) . '/' . sanitize($crow['slug']) . '.html' : $core->site_url . '/item.php?pid=' . intval($crow['pid']);?>
          <?php $status = ($crow['price'] == 0) ? '<a href="'.SITEURL.'/download.php?fid='.$crow['pid'].'" class="download-small">دانـلــود</a>' : '<a href="javascript:void(0);" class="add-to-cart" id="item_'.$crow['pid'].'">اضـافـه بـه سبـد خـریـد</a>';?>
          <div class="toolbar">
            <ul>
              <li class="addcart"><?php echo $status;?></li>
              <li><img src="<?php echo SITEURL; ?>/images/calendar.png" alt="" class="tooltip" title="ایجـاد شـده"/><?php echo $crow['cdate'];?></li>
              <li><img src="<?php echo SITEURL; ?>/images/hits.png" alt="" class="tooltip" title="بـازدیـد شـده"/><?php echo $crow['hits'];?></li>
              <li><img src="<?php echo SITEURL; ?>/images/rate.png" alt="" class="tooltip" title="امتیـاز"/><?php echo $crow['rating'];?></li>
              <?php if($crow['audio']):?>
              <li><img src="<?php echo SITEURL; ?>/images/audio-gray.png" alt="" class="tooltip" title="پیـش نمـایـش صـوتـی"/>a</li>
              <?php endif;?>
              <li><img src="<?php echo SITEURL; ?>/images/dollar-gray.png" alt="" /><?php echo $core->formatMoney($crow['price']);?></li>
            </ul>
            <br clear="right" />
          </div>
          <span class="thumb flright"><a href="<?php echo $url;?>" class="tooltip" title="<?php echo $crow['title'];?>"><img src="<?php echo $thumb;?>" alt=""/></a></span>
          <div class="description">
            <h1><a href="<?php echo $url;?>"><?php echo sanitize($crow['title']);?></a></h1>
            <?php echo sanitize(cleanOut($crow['description']),350);?> <span class="readmore"><a href="<?php echo $url;?>" class="read-more">ادامـه مطلـب</a></span> </div>
          <br clear="right" />
          <div class="ruler"></div>
        </div>
        <?php endforeach;?>
        <div class="clear"></div>
      </div>
    </div>
    <div class="clear"></div>
  </div> 
<?php endif;?>
<!-- End Search/-->
<?php include("footer.php");?>